// AcMapOAddCmdSaveBlocks.h: interface for the AcMapOAddCmdSaveBlocks class.
//
// (C) Copyright 2001 by Autodesk, Inc. 
//
// Permission to use, copy, modify, and distribute this software in
// object code form for any purpose and without fee is hereby granted, 
// provided that the above copyright notice appears in all copies and 
// that both that copyright notice and the limited warranty and
// restricted rights notice below appear in all supporting 
// documentation.
//
// AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS. 
// AUTODESK SPECIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF
// MERCHANTABILITY OR FITNESS FOR A PARTICULAR USE.  AUTODESK, INC. 
// DOES NOT WARRANT THAT THE OPERATION OF THE PROGRAM WILL BE
// UNINTERRUPTED OR ERROR FREE.
//
// Use, duplication, or disclosure by the U.S. Government is subject to 
// restrictions set forth in FAR 52.227-19 (Commercial Computer
// Software - Restricted Rights) and DFAR 252.227-7013(c)(1)(ii)
// (Rights in Technical Data and Computer Software), as applicable.
//
// CREATED BY:
// David Barbour, March 2001
//
// DESCRIPTION:
// 	Declaration of class AcMapOAddCmdSaveBlocks


#if !defined(AFX_ACMAPOADDCMDSAVEBLOCKS_H__5A1ABDF2_F7DB_11D4_95B3_0010B547D103__INCLUDED_)
#define AFX_ACMAPOADDCMDSAVEBLOCKS_H__5A1ABDF2_F7DB_11D4_95B3_0010B547D103__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

//Include files
#include "AcMapOracleReactor.h" // for AcMapOracle Reactors
#include <set>


//*****************************************************************************             
// forward declarations
class AcDbDatabase;
class AcMapOracleConnection;
class ODatabase;



//*****************************************************************************             
//class saves blocks during ORAEXPORT

class AcMapOReactorSaveBlocks 
	: public AcMapOracleConnectionReactor, public AcMapOracleExportReactor  
{
public:
	AcMapOReactorSaveBlocks();
	virtual ~AcMapOReactorSaveBlocks();

	virtual void SchemaChanged();
	virtual void Disconnected();
	virtual void ObjectCached(AcDbEntity *pObj, unsigned long lOracleID);
	virtual void ObjectsExported(std::vector<unsigned long> &vOracleIDs);

private:
	// private functions
	void Clean();
	void HandleBlockRef(AcDbBlockReference *pBlockRef);
	bool CheckAndCreateTable();
	bool IsBlockAlreadySaved(const char *pName);
	bool SaveBlock(
		const char *pName,
		AcDbBlockTableRecord *pBlock,
		AcDbObjectId& blockId);

private:
	// private member variables
	AcMapOracleConnection *m_pConnection;
	ODatabase m_oDatabase;
	AcDbDatabase *m_pDb;
	struct less_ignore_case : std::less <const std::string>
	{
	    bool operator()(const std::string& s1, const std::string& s2) const;
	};

	typedef std::set<
	        std::string,
	        less_ignore_case,
	        std::allocator<std::string> >
	StringSet;
	StringSet m_savedBlocks;
	typedef std::map<unsigned long, AcDbObjectId> MapOracleId2AcadId;
	MapOracleId2AcadId m_mapOra2AcadIds;
};

#endif // !defined(AFX_ACMAPOADDCMDSAVEBLOCKS_H__5A1ABDF2_F7DB_11D4_95B3_0010B547D103__INCLUDED_)
